# @(#)09   1.1   src/rsct/dbi/DBD/Parser.pm.perl, dbi, rsct_rzauh, rzauhbase 3/31/03 16:54:01
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
# DBD::Parser is SQL Parser that currently supports CREATE, DROP, INSERT,     #
# UPDATE, DELETE and SELECT operations. It does not support all SQL Data Types#
# The data types it can support include integer, real, float, char, varchar,  #
# bigint. Currently SQL data types are mapped to Registry Data types.         #								
require 5.004;
use strict;

my $stmtcmd = "SQL COMMAND";

package DBD::Parser;
sub command
{
 my ($statement) = @_;
 if ($statement =~ /^CREATE TABLE /)
    {
     $stmtcmd = 'CREATE';
    }
 elsif ($statement =~ /^DROP TABLE /)
    {
     $stmtcmd = 'DROP';
    }
 elsif ($statement =~ /^INSERT INTO /)
    {
     $stmtcmd = 'INSERT';
    }
 elsif ($statement =~ /^UPDATE /)
    {
     $stmtcmd = 'UPDATE';
    }
 elsif ($statement =~ /^DELETE FROM /)
    {
     $stmtcmd = 'DELETE';
    }
 elsif ($statement =~ /^SELECT /)
    {
     $stmtcmd = 'SELECT';
    }
 else
    {
     print "Error: RSCT DBD does not support this command $statement.\n";
     $stmtcmd = undef;
    }
 return ($stmtcmd);
} 

sub table
{
 my ($statement) = @_;
 my @splitcmd;
 my $tablestr;
 @splitcmd = split(/ /, $statement);
 if ($stmtcmd =~ /^CREATE$|^DROP$|^INSERT$|^DELETE$/)
    {
     $tablestr = $splitcmd[2];               
    }
 elsif ($stmtcmd =~ /^UPDATE$/)
    {
     $tablestr = $splitcmd[1];
    }
 elsif ($stmtcmd =~ /^SELECT$/)
    {
     my @sepFrom = split(/\sFROM\s/i, $statement);
     $tablestr = $sepFrom[1];
    } 
 else
    {
     print "RSCT DBD does not support this command $statement.\n";
     $tablestr = undef;
    }
 return($tablestr);
 } 

sub columns
 {
  my ($statement) = @_;
  my @column_names;
  my @columns;
  my @col_pairs;
  my @data_types;
  my $i;
  if ($stmtcmd =~ /^SELECT$/)
     {
      my($beforeFrom,$afterFrom)= split(/\sFROM\s/i, $statement);
      my $tempCol =substr($beforeFrom,7);
      @column_names = split(/, /,$tempCol);
     }
  elsif ($stmtcmd =~ /^INSERT$/)
     {
      $_ = $statement;
      if (/\((.*?)\)/)
         {
          @column_names = split(/, /,$1);
         }
      else
         {
          die "Error in SQL INSERT syntax\n";
         }
     }
  elsif ($stmtcmd =~ /^UPDATE$/)
     {  
       my @row_values;
       my($beforeSET,$afterSET)= split(/\sSET\s/i, $statement);
       my @col_pairs = split(/, /,$afterSET);
       for ($i=0; $i<@col_pairs; $i++)
           {
            ($column_names[$i], $row_values[$i]) = split(/\s=\s/i, $col_pairs[$i]);
           }
     }
  elsif ($stmtcmd =~ /^CREATE$/)
     {
      #$sqlstmt = "CREATE TABLE People (LastName CHAR(8), SSN bigint, Height float)";
      $_ = $statement;
      if (/\s\((.*?)\)$/)
         {
          @col_pairs = split(/, /,$1);
         }
      for ($i=0; $i<@col_pairs; $i++)
          {
           ($column_names[$i], $data_types[$i]) = split(/\s/, $col_pairs[$i]);
          }
      for ($i=0; $i<@data_types; $i++)
          {
           if ($data_types[$i] =~ /^integer$/i) {$columns[$i]->{'type'} = "i";}
           elsif ($data_types[$i] =~ /^bigint$/i) {$columns[$i]->{'type'} = "l";}
           elsif ($data_types[$i] =~ /^real$/i) { $columns[$i]->{'type'} = "f";}
           elsif ($data_types[$i] =~ /^float$/i) { $columns[$i]->{'type'} = "d";}
           elsif ($data_types[$i] =~ /^varchar\(\d+\)$|^char\(\d+\)$/i) { $columns[$i]->{'type'} = "s";}
           else {die "RSCT DBD does not currently support this data type $data_types[$i].\n";}
           }
     } 
   for ($i=0; $i<@column_names; $i++)
       {
        $columns[$i]->{'name'}= $column_names[$i];
       }
  return (@columns);
 }

sub row_values
  {
   my ($statement) = @_;
   my @row_values;
   my $i;
   if ($stmtcmd =~ /^INSERT$/)
      {
       my($beforeVal,$afterVal)= split(/\sVALUES\s/i, $statement);
       $afterVal =~ s/^\(//;
       $afterVal =~ s/\)$//;
       @row_values = split(/, /,$afterVal);
      }
   elsif ($stmtcmd =~ /^UPDATE$/)
      {
       my @col_names;
       my($beforeSET,$afterSET)= split(/\sSET\s/i, $statement);
       my @col_pairs = split(/, /,$afterSET);
       for ($i=0; $i<@col_pairs; $i++)
           {
            ($col_names[$i], $row_values[$i]) = split(/\s=\s/i, $col_pairs[$i]);
           }
      }
   else
      {
       die "RSCT DBD does not currently support this command $statement.\n";
      }
   return (@row_values);
  }


